<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('banned_ips')) {
            Schema::create('banned_ips', function (Blueprint $table) {
                $table->id();
                $table->string('ip_address')->unique();
                $table->text('reason')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('banned_ips');
    }
};