<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('catalogs')) {
            Schema::create('catalogs', function (Blueprint $table) {
                $table->id();
                $table->string('title');
                $table->string('file');
                $table->boolean('status')->default(true);
                $table->integer('order')->default(0);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('catalogs');
    }
};