<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('completed_projects')) {
            Schema::create('completed_projects', function (Blueprint $table) {
                $table->id();
                $table->string('project_name');
                $table->dateTime('start_date');
                $table->dateTime('end_date')->nullable();
                $table->string('location')->nullable();
                $table->boolean('status')->default(true);
                $table->text('description')->nullable();
                $table->string('featured_image')->nullable();
                $table->unsignedInteger('order')->default(0);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('completed_projects');
    }
};