<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('feature_orders')) {
            Schema::create('feature_orders', function (Blueprint $table) {
                $table->id();
                $table->string('feature_key');
                $table->unsignedInteger('order')->default(0);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('feature_orders');
    }
};