<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('feature_settings')) {
            Schema::create('feature_settings', function (Blueprint $table) {
                $table->id();
                $table->string('feature_key')->unique();
                $table->boolean('is_active')->default(1);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('feature_settings');
    }
};