<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('footer_columns')) {
            Schema::create('footer_columns', function (Blueprint $table) {
                $table->id();
                $table->string('title');
                $table->integer('order')->default(0);
                $table->integer('grid')->default(3);
                $table->boolean('is_active')->default(1);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('footer_columns');
    }
};