<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('homepage_limits')) {
            Schema::create('homepage_limits', function (Blueprint $table) {
                $table->id();
                $table->string('feature_key')->unique();
                $table->integer('limit')->default(3);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('homepage_limits');
    }
};