<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('menus')) {
            Schema::create('menus', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('parent_id')->nullable();
                $table->string('title');
                $table->string('url')->nullable();
                $table->integer('order')->default(0);
                $table->timestamps();

                $table->foreign('parent_id')
                      ->references('id')->on('menus')
                      ->onDelete('cascade');

                $table->index('parent_id', 'menus_parent_id_foreign');
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('menus');
    }
};