<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('project_images')) {
            Schema::create('project_images', function (Blueprint $table) {
                $table->id();
                $table->foreignId('project_id')->constrained('completed_projects')->onDelete('cascade');
                $table->string('image_path');
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('project_images');
    }
};