<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('smtp_settings')) {
            Schema::create('smtp_settings', function (Blueprint $table) {
                $table->id();
                $table->string('mailer')->default('smtp');
                $table->string('host');
                $table->string('port');
                $table->string('username');
                $table->string('password');
                $table->string('encryption')->nullable();
                $table->string('from_address');
                $table->string('from_name');
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('smtp_settings');
    }
};