<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('video_galleries')) {
            Schema::create('video_galleries', function (Blueprint $table) {
                $table->id();
                $table->string('title')->nullable();
                $table->string('cover_image')->nullable();
                $table->text('embed_link')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('video_galleries');
    }
};