<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('video_files')) {
            Schema::create('video_files', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('video_gallery_id');
                $table->string('video_path');
                $table->timestamps();

                $table->foreign('video_gallery_id')
                      ->references('id')
                      ->on('video_galleries')
                      ->onDelete('cascade');
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('video_files');
    }
};