<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        if (!Schema::hasTable('users')) {
            Schema::create('users', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('email')->unique();
                $table->timestamp('email_verified_at')->nullable();
                $table->string('password');
                $table->string('profile_photo')->nullable();
                $table->boolean('two_factor_enabled')->default(false);
                $table->text('two_factor_secret')->nullable();
                $table->enum('role', ['admin', 'editor', 'demo'])->default('editor');
                $table->rememberToken();
                $table->timestamps();
                $table->unsignedBigInteger('role_id')->nullable();

                $table->foreign('role_id')->references('id')->on('roles')->onDelete('set null');
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('users');
    }
};