<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('activity_logs', function (Blueprint $table) {
    $table->id();
    $table->string('model_type'); // Model sınıf adı, örn: App\Models\Blog
    $table->unsignedBigInteger('model_id')->nullable(); // Model kayıt id'si
    $table->string('action'); // created, updated, deleted
    $table->unsignedBigInteger('user_id')->nullable(); // işlemi yapan admin id'si
    $table->json('changes')->nullable(); // yapılan değişiklikler (updated ise)
    $table->timestamps();

    $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};
