<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('blog_comments', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('blog_id');
    $table->string('name');
    $table->string('email')->nullable();
    $table->text('comment');
    $table->boolean('is_approved')->default(false);
    $table->unsignedBigInteger('parent_id')->nullable(); // admin cevabı için
    $table->timestamps();

    $table->foreign('blog_id')->references('id')->on('blogs')->onDelete('cascade');
    $table->foreign('parent_id')->references('id')->on('blog_comments')->onDelete('cascade');
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_comments');
    }
};
